<?php
/* --------------------------------------------------------------
   FetchSpecificParcelServiceAction.php 2020-04-09
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Api\ParcelService\Actions;

use Gambio\Admin\ParcelService\Exceptions\ParcelServiceNotFoundException;
use Gambio\Admin\ParcelService\Interfaces\ParcelServiceService;
use Gambio\Admin\ParcelService\Model\ParcelServiceId;
use Gambio\Api\Application\Responses\CreateApiMetaDataTrait;
use Slim\Http\Response;
use Slim\Http\ServerRequest as Request;

/**
 * Class FetchSpecificParcelServiceAction
 *
 * @package Gambio\Api\ParcelService\Actions
 */
class FetchSpecificParcelServiceAction
{
    use CreateApiMetaDataTrait;
    
    /**
     * @var ParcelServiceService
     */
    private $service;
    
    
    /**
     * FetchSpecificParcelServiceAction constructor.
     *
     * @param ParcelServiceService $service
     */
    public function __construct(ParcelServiceService $service)
    {
        $this->service = $service;
    }
    
    
    /**
     * @param Request  $request
     * @param Response $response
     * @param array    $args
     *
     * @return Response
     */
    public function __invoke(Request $request, Response $response, array $args): Response
    {
        try {
            $parcelServiceId = ParcelServiceId::create((int)$request->getAttribute('id'));
            $parcelService   = $this->service->getParcelServiceById($parcelServiceId);
            $metaData        = $this->createApiMetaData();
            
            return $response->withJson([
                                           'data'  => $parcelService,
                                           '_meta' => $metaData,
                                       ]);
        } catch (ParcelServiceNotFoundException $e) {
            return $response->withStatus(404);
        }
    }
}